package gov.va.genisis2.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.RoleTypeDTO;
import gov.va.genisis2.model.RoleType;

/**
 * This class is used to convert RoleTypeDTO to RoleType entity and vice-versa.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Component
public class RoleTypeConverter implements Converter<RoleType, RoleTypeDTO> {

	@Override
	public RoleTypeDTO convert(RoleType roleType) {
		RoleTypeDTO roleTypeDto = new RoleTypeDTO();

		roleTypeDto.setRoleTypeId(roleType.getRoleTypeId());
		roleTypeDto.setRoleName(roleType.getRoleName());
		roleTypeDto.setRoleDescription(roleType.getRoleDescription());

		return roleTypeDto;
	}

	public RoleType convert(RoleTypeDTO roleTypeDto) {
		RoleType roleType = new RoleType();

		roleType.setRoleTypeId(roleTypeDto.getRoleTypeId());
		roleType.setRoleName(roleTypeDto.getRoleName());
		roleType.setRoleDescription(roleTypeDto.getRoleDescription());

		return roleType;
	}
}